Here’s the updated **README.md**, with a new **Data Sources** section that documents exactly where each dataset comes from:

````markdown
# Volume 1 Fractal‑Pivot Calibration

This repository contains a self‑contained Python pipeline for computing  
box‑counting fractal dimensions on a collection of point‑set datasets  
and fitting a two‑parameter logistic “pivot” model to the resulting  
curve. The pipeline also produces summary tables and visualization  
plots for each dataset.

---

## Contents

* `data/` – input datasets (see **Data Sources** below):  
  - Synthetic IFS fractals (Barnsley fern, Sierpinski triangle)  
  - Neuronal point clouds (rat hippocampus)  
  - Cosmic‑web galaxy slices (SDSS)  
  - LiDAR point cloud (USGS 3DEP)  
  - DEM topography tiles (NASA SRTM)  
* `src/` – Python source code for data loading, box‑counting  
  estimation, logistic‑pivot fitting, and plotting  
* `results/` – outputs generated by the pipeline (`*_D_raw.csv`,  
  `*_pivot.png`, `summary.csv`)  
* `requirements.txt` – Python dependencies  

---

## Data Sources

1. **Synthetic Fractals**  
   - **Barnsley Fern** (`barnsley_fern.csv`, 100 k points)  
   - **Sierpinski Triangle** (`sierpinski_triangle.csv`, 50 k points)

2. **Neuronal Morphologies** (`points_neuro.csv`)  
   - **Source:** NeuroMorpho.Org  
   - **Content:** Public, peer‑reviewed 3D reconstructions of rat hippocampal  
     pyramidal cells (n400–n415). Original SWC/CSV exports include IDs  
     and morphometric metadata; we strip out non‑numeric columns to get  
     raw (X, Y, Z) coordinates in microns.

3. **Cosmic‑Web Galaxy Slice** (`galaxies_balanced_xyz.csv`)  
   - **Source:** Sloan Digital Sky Survey (SDSS) public catalog  
   - **Content:** RA/Dec/redshift for galaxies in a 10° × 10° patch (RA=180–190°,  
     Dec=30–40°). Converted to comoving (X, Y, Z) in Mpc using Astropy’s  
     Planck15 cosmology.

4. **LiDAR Point Cloud** (`lidar_data.zip` → `lidar_points.npy`)  
   - **Source:** USGS 3DEP public AWS bucket (via OpenTopography bulk download)  
   - **Content:** “CVPR 2009 Oakland” test subset (~1 km², ~100 k points)  
     provided as ASCII, repackaged to NumPy array in meters.

5. **Digital Elevation Model (DEM)** (`dem_data.zip` → `dem/*.hgt`)  
   - **Source:** NASA SRTM 1-arc‑second tiles (mirrored by USGS/AWS)  
   - **Content:** A 3×3 mosaic of contiguous .hgt files at ~30 m resolution.  
     Merged with Rasterio into a single 2D elevation array (meters).

---

## Usage

```bash
pip install -r requirements.txt
python src/main.py
````

* Outputs (`*_D_raw.csv`, `*_pivot.png`, and `summary.csv`) will appear under `results/`.
* Each `*_D_raw.csv` has columns `n` (scale index) and `D_raw` (box‑counted dimension).
* Each `*_pivot.png` overlays the raw points with the fitted logistic pivot.
* `summary.csv` aggregates `dataset,k,n0,R2,N_points` for all five inputs.

---

## License

This project is provided under the MIT License. See `LICENSE` for details.

```
